/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigKeyBind;
import org.figuramc.figura.config.ConfigManager;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.screens.ConfigScreen;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.config.CategoryWidget;
import org.figuramc.figura.gui.widgets.config.InputElement;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.utils.ui.UIHelper;

public class ConfigList
extends AbstractList {
    private final List<CategoryWidget> configs = new ArrayList<CategoryWidget>();
    public final ConfigScreen parentScreen;
    public KeyMapping focusedBinding;
    private int totalHeight = 0;

    public ConfigList(int x, int y, int width, int height, ConfigScreen parentScreen) {
        super(x, y, width, height);
        this.parentScreen = parentScreen;
        this.updateList();
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        this.totalHeight = -4;
        int visibleConfig = 0;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            this.totalHeight += config.getHeight() + 8;
            ++visibleConfig;
        }
        int entryHeight = visibleConfig == 0 ? 0 : this.totalHeight / visibleConfig;
        this.scrollBar.setVisible(this.totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, this.totalHeight - height);
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.lerp((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(this.totalHeight - height))) : 4;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            config.setX(x + xOffset);
            config.setY(y + yOffset);
            yOffset += config.getHeight() + 8;
        }
        super.render(gui, mouseX, mouseY, delta);
        gui.disableScissor();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (CategoryWidget categoryWidget : this.configs) {
            for (GuiEventListener guiEventListener : categoryWidget.children()) {
                if (!(guiEventListener instanceof InputElement)) continue;
                InputElement inputElement = (InputElement)guiEventListener;
                TextField field = inputElement.getTextField();
                field.getField().setFocused(field.isEnabled() && field.isMouseOver(mouseX, mouseY));
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void updateList() {
        for (CategoryWidget config : this.configs) {
            this.children.remove(config);
        }
        this.configs.clear();
        for (ConfigType.Category category : ConfigManager.CATEGORIES_REGISTRY.values()) {
            CategoryWidget widget = new CategoryWidget(this.getWidth() - 22, category, this);
            for (ConfigType<?> config : category.children) {
                widget.addConfig(config);
            }
            this.configs.add(widget);
            this.children.add(widget);
        }
        for (CategoryWidget config : this.configs) {
            config.setShowChildren(config.isShowingChildren());
        }
    }

    public void updateScroll() {
        double pastScroll = (double)(this.totalHeight - this.getHeight()) * this.scrollBar.getScrollProgress();
        this.totalHeight = -4;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            this.totalHeight += config.getHeight() + 8;
        }
        this.scrollBar.setScrollProgress(pastScroll / (double)(this.totalHeight - this.getHeight()));
    }

    public boolean hasChanges() {
        for (CategoryWidget config : this.configs) {
            if (!config.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean updateKey(InputConstants.Key key) {
        if (this.focusedBinding == null) {
            return false;
        }
        this.focusedBinding.setKey(key);
        if (this.focusedBinding instanceof ConfigKeyBind) {
            ((ConfigKeyBind)this.focusedBinding).saveConfigChanges();
        }
        this.focusedBinding = null;
        FiguraMod.processingKeybind = false;
        this.updateKeybinds();
        return true;
    }

    public void updateKeybinds() {
        for (CategoryWidget widget : this.configs) {
            widget.updateKeybinds();
        }
    }

    public void updateSearch(String query) {
        for (CategoryWidget widget : this.configs) {
            widget.updateFilter(query);
        }
    }
}

